/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.javatime;

import java.sql.ResultSet;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaDurationColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "", "value", "", "nonNullValueToString", "(Ljava/lang/Object;)Ljava/lang/String;", "notNullValueToDB", "(Ljava/lang/Object;)Ljava/lang/Object;", "Ljava/sql/ResultSet;", "rs", "", "index", "readObject", "(Ljava/sql/ResultSet;I)Ljava/lang/Object;", "sqlType", "()Ljava/lang/String;", "Ljava/time/Duration;", "valueFromDB", "(Ljava/lang/Object;)Ljava/time/Duration;", "<init>", "()V", "Companion", "exposed-java-time"})
public final class JavaDurationColumnType
extends ColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final JavaDurationColumnType INSTANCE = new JavaDurationColumnType();

    public JavaDurationColumnType() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().longType();
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Object value2) {
        Duration duration;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Object object = value2;
        if (object instanceof String) {
            return (String)value2;
        }
        if (object instanceof Duration) {
            duration = (Duration)value2;
        } else if (object instanceof Long) {
            duration = Duration.ofNanos(((Number)value2).longValue());
        } else if (object instanceof Number) {
            duration = Duration.ofNanos(((Number)value2).longValue());
        } else {
            throw new IllegalStateException(("Unexpected value: " + value2 + " of " + Reflection.getOrCreateKotlinClass(value2.getClass()).getQualifiedName()).toString());
        }
        Duration duration2 = duration;
        return "" + '\'' + duration2.toNanos() + '\'';
    }

    @Override
    @NotNull
    public Duration valueFromDB(@NotNull Object value2) {
        Duration duration;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Object object = value2;
        if (object instanceof Long) {
            Duration duration2 = Duration.ofNanos(((Number)value2).longValue());
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofNanos(value)");
            duration = duration2;
        } else if (object instanceof Number) {
            Duration duration3 = Duration.ofNanos(((Number)value2).longValue());
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofNanos(value.toLong())");
            duration = duration3;
        } else if (object instanceof String) {
            Duration duration4 = Duration.parse((CharSequence)value2);
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"parse(value)");
            duration = duration4;
        } else {
            duration = this.valueFromDB(value2.toString());
        }
        return duration;
    }

    @Override
    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        Long l = rs.getLong(index);
        long it = ((Number)l).longValue();
        boolean bl = false;
        return rs.getObject(index) != null ? l : null;
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (value2 instanceof Duration) {
            return ((Duration)value2).toNanos();
        }
        return value2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0003\u001a\u00020\u00028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaDurationColumnType$Companion;", "", "Lorg/jetbrains/exposed/sql/javatime/JavaDurationColumnType;", "INSTANCE", "Lorg/jetbrains/exposed/sql/javatime/JavaDurationColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/javatime/JavaDurationColumnType;", "<init>", "()V", "exposed-java-time"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaDurationColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

